<?php
class MalwareCheck implements themecheck {
	protected $error = array();

	function check( $php_files, $css_files, $other_files ) {
		$ret = true;

		$checks = array(
			'/[^a-z0-9](?<!_)(file_get_contents|curl_exec|curl_init|readfile|fopen|fsockopen|pfsockopen|fclose|fread|fwrite|file_put_contents)\s?\(/' => __( 'File operations should use the WP_Filesystem methods instead of direct PHP filesystem calls', 'theme-check' ),
			);

		foreach ( $php_files as $php_key => $phpfile ) {
			foreach ( $checks as $key => $check ) {
				checkcount();

				if ( preg_match_all( $key, $phpfile, $matches ) ) {
					$filename = tc_filename( $php_key );

						foreach ($matches[1] as $match ) {
							$error = ltrim( $match, '(' );
							$error = rtrim( $error, '(' );
							$grep = tc_grep( $error, $php_key );
							$this->error[] = sprintf('<span class="tc-lead tc-warning">'.__('WARNING','theme-check').'</span>: '.__('%1$s was found in the file %2$s %3$s.%4$s', 'theme-check'), '<strong>' . $error. '</strong>', '<strong>' . $filename . '</strong>', $check, $grep );
							$ret = false;
						}
				}
			}
		}
		return $ret;
	}

	function getError() { return $this->error; }
}
$themechecks[] = new MalwareCheck;
