<?php
/**
 * The template for displaying Category Archive pages.
 *
 * @package WordPress
 * @subpackage meeblog
 * @since meeblog 3.0
 */

get_header(); ?>
	<div id="wrapper" class="clearfix">
		
		<div id="box-content">
		
				<h1><?php
					printf( __( 'Category Archives: %s', 'twentyten' ), '' . single_cat_title( '', false ) . '' );
				?></h1>
				<?php
					$category_description = category_description();
					if ( ! empty( $category_description ) )
						echo '' . $category_description . '';

				/* Run the loop for the category page to output the posts.
				 * If you want to overload this in a child theme then include a file
				 * called loop-category.php and that will be used instead.
				 */
				//get_template_part( 'loop', 'category' );
				?>
				
				<?php if(have_posts()) : while(have_posts()) : the_post(); ?>

					<div class="post-item clearfix type-post">
						<div class="post">
							<table cellspacing="0" cellpadding="0" border="0"><tbody><tr><td valign="bottom">
							<div class="published">
								<span class="day"><?php the_time( 'l' ); ?></span><br />
								<p><?php the_time( 'F j,' ); ?></span><br />
								<?php the_time( 'Y' ); ?></p>
							</div>
							</td>
							<td valign="bottom">
								<div class="blurb-title">
								<h3><?php the_category(', ');?></h3>
								<a href="<?php the_permalink('');?>"><?php the_title();?></a>
								</div>
							</td>
							<td valign="bottom">
								<div class="comments">
									<a href="<?php comments_link();?>"><?php comments_number('0 ', '1 ', '% ');?></a> comments
								</div>
							</td></tr></tbody></table>
							
							<div class="cl border"></div>
							<div class="blurb-pic"><?php the_post_thumbnail( array (119, 119) );?>
								<?php if (!has_post_thumbnail()) { ?>
									<img src="<?php bloginfo('template_url'); ?>/images/no-image.jpg" alt="no-image" width="119" height="119" />
								<?php } ?>
							</div>
							<div class="blurb">
								<?php excerpt('30'); ?>
								<div class="by">&mdash; by <?php the_author(); ?></div>
							</div>
							<div class="single-share">
								<?php
								if(function_exists('display_social4i'))
								echo display_social4i("small","float-right");
								?>
							</div>
						</div>
					</div><!--End .post-item-->
				<?php endwhile; ?>
				
				<?php else : ?>
				<div class="post-item clearfix type-post">
					<p>Sorry There are no posts to display, oh man!</p>
				</div>
				<?php endif;  ?>
				<div style="margin-top: 15px; clear: both;"><?php wp_pagenavi(); ?></div>
				
		</div><!-- #box-content -->
		<?php get_sidebar(); ?>
	</div><!--end #Wrapper-->
<?php get_footer(); ?>