<?php
/**
 * The Template for displaying all single posts.
 *
 * @package WordPress
 * @subpackage meeblog
 * @since meeblog 3.0
 */

get_header(); ?>
	<div id="wrapper" class="clearfix">
		
		<div id="box-content">
			<div class="type-post">
				<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
					<table cellspacing="0" cellpadding="0" border="0"><tbody><tr><td valign="bottom">
					<div class="published">
						<span class="day"><?php the_time( 'l' ); ?></span><br />
						<p><?php the_time( 'F j,' ); ?></span><br />
						<?php the_time( 'Y' ); ?></p>
					</div>
					</td>
					<td valign="bottom">
						<div class="blurb-title">
						<h3><?php the_category(', ');?></h3>
						<a href="<?php the_permalink('');?>"><?php the_title();?></a>
						</div>
					</td>
					<td valign="bottom">
						<div class="comments">
							<a href="<?php comments_link();?>"><?php comments_number('0 ', '1 ', '% ');?></a> comments
						</div>
					</td></tr></tbody></table>
					
					<div class="post-content">
						<div class="single-share">
							<?php if(function_exists('display_social4i'))
							echo display_social4i("small","float-right"); ?>
						</div>
						
						<?php //if(get_field('add_banner')): ?>
							<div class="google-ad">
								<?php if ( is_active_sidebar( 'banner-top-widget-area' ) ) : ?>				
									<?php dynamic_sidebar( 'banner-top-widget-area' ); ?>
								<?php endif; ?>
							</div>
						<?php //endif; ?>
						
						
						<div class="author">by <strong><?php the_author(); ?></strong></div>
						<?php the_content() ?>
						<div id="banner_cont">
							<?php if ( is_active_sidebar( 'banner-content-widget-area' ) ) : ?>				
								<?php dynamic_sidebar( 'banner-content-widget-area' ); ?>
							<?php endif; ?>
						</div>
					</div>
					<div id="banner_bottom">
						<?php if ( is_active_sidebar( 'banner-footer-widget-area' ) ) : ?>				
							<?php dynamic_sidebar( 'banner-footer-widget-area' ); ?>
						<?php endif; ?>
					</div>

					<?php edit_post_link( __( 'Edit', 'twentyten' ), '', '' ); ?>

				<?php comments_template( '', true ); ?>

				<?php endwhile; // end of the loop. ?>
			</div>
		</div><!-- #box-content -->
		<?php get_sidebar(); ?>
	</div><!--end #Wrapper-->
<?php get_footer(); ?>