<?php
/**
 * Template Name: Post group by year
 *
 */
?>

<?php get_header(); ?>	
	<div id="wrapper" class="clearfix">
		
		<div id="box-content" class="display_year">
			<div class="post-item clearfix type-post">
				<div class="qick_menu">
					<a class="active tab" title="list_year" href="#">By Year</a>
					<a class="last tab" title="list_category" href="#">By Category</a>
				</div><!-- .quick_menu -->
				<div class="sep"></div>				
				<div id="list_year" class="listCont">
					<?php query_posts(array('nopaging' => 1, /* we want all posts, so disable paging. Order by date is default */));
					$prev_year = null;
					if ( have_posts() ) {
					   while ( have_posts() ) {
						  the_post();
						  $this_year = get_the_date('Y');
						  if ($prev_year != $this_year) {
							  // Year boundary
							  if (!is_null($prev_year)) {
								 // A list is already open, close it first
								 echo '</div>';
							  }
							  echo '<h4><a href="#">' . $this_year . '</a></h4>';
							  echo '<div class="show-year year_'. $this_year .'">';
						  }
						  echo '<li>'; ?>
							<a class="b-y-c" href="<?php the_permalink('');?>"><?php the_title();?></a>
							<?php the_category(', ');?>
						  <?php
						  echo '</li>';
						  $prev_year = $this_year;
					   }
					   echo '</div>';
					}  ?>
				</div>
				
				<div id="list_category" class="listCont" style="display:none;">
					<?php
					// get all the categories from the database
					$cats = get_categories(); 
		 
						// loop through the categries
						foreach ($cats as $cat) {
							// setup the cateogory ID
							$cat_id= $cat->term_id;
							// Make a header for the cateogry
							echo '<h4><a href="#">'.$cat->name .'</a></h3>';
							// create a custom wordpress query
							query_posts("cat=$cat_id&post_per_page=100");
							echo '<div class="show-year '.$cat->name.'">';
							// start the wordpress loop!
							if (have_posts()) : while (have_posts()) : the_post(); ?>
		 
								<?php // create our link now that the post is setup ?>
								<a href="<?php the_permalink();?>"><?php the_title(); ?></a>
		 
							<?php endwhile; endif; // done our wordpress loop. Will start again for each category ?>
							</div>
						<?php } // done the foreach statement ?>
				</div>
			</div><!-- .type-post -->
 		</div><!-- #box-content -->
 		<?php get_sidebar(); ?>
    </div><!--end #wrapper-->

	
<?php get_footer(); ?>