<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package WordPress
 * @subpackage meeblog
 * @since meeblog 3.0
 */

get_header(); ?>
	<div id="wrapper" class="clearfix">
		
		<div id="box-content">
			<div class="post-item clearfix content-trans">
				<h1><?php printf( __( 'Search Results for: %s', 'twentyten' ), '' . get_search_query() . '' ); ?></h1>
				<div class="gsc-search-box"><?php get_search_form(); ?></div>
			<?php if ( have_posts() ) : while(have_posts()) : the_post(); ?>
				
						<div class="post gsc-result clearfix">		
							<div class="sea-blurb-pic"><?php the_post_thumbnail( array (62, 50) );?>
								<?php if (!has_post_thumbnail()) { ?>
									<img src="<?php bloginfo('template_url'); ?>/images/no-image.jpg" alt="no-image" width="62" height="50" />
								<?php } ?>
							</div>
							<div class="sea-blurb">
								<div class="gs-title"><a href="<?php the_permalink('') ?>"><?php the_title();?></a></div>
								<?php excerpt('30'); ?>
								<div class="by"><?php the_permalink('') ?></div>
							</div>
						</div>
				<?php endwhile; ?>
			<?php else : ?>
				<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'twentyten' ); ?></p>		
			<?php endif; ?>
			</div>
			
		</div><!-- #box-content -->
		<?php get_sidebar(); ?>
	</div><!--end #Wrapper-->
<?php get_footer(); ?>
